/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.networking;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.netty.buffer.ByteBuf;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.FabricServerConfigurationNetworkHandler;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.impl.networking.FabricRegistryByteBuf;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.neoforged.neoforge.common.extensions.IServerConfigurationPacketListenerExtension;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.sinytra.fabric.networking_api.NeoListenableNetworkHandler;
import org.sinytra.fabric.networking_api.server.NeoServerConfigurationNetworking;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerConfigurationPacketListenerImpl.class}, priority=900)
public abstract class ServerConfigurationNetworkHandlerMixin
implements FabricServerConfigurationNetworkHandler,
NeoListenableNetworkHandler {
    @Shadow
    @Final
    private Queue<ConfigurationTask> configurationTasks;

    @Override
    public void addTask(ConfigurationTask task) {
        this.configurationTasks.add(task);
    }

    @Override
    public void completeTask(ConfigurationTask.Type key) {
        ((IServerConfigurationPacketListenerExtension)this).finishCurrentTask(key);
    }

    @WrapOperation(method={"handleConfigurationFinished"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/RegistryFriendlyByteBuf;decorator(Lnet/minecraft/core/RegistryAccess;Lnet/neoforged/neoforge/network/connection/ConnectionType;)Ljava/util/function/Function;")})
    private Function<ByteBuf, RegistryFriendlyByteBuf> bindChannelInfo(RegistryAccess registryManager, ConnectionType connectionType, Operation<Function<ByteBuf, RegistryFriendlyByteBuf>> original) {
        return ((Function)original.call(new Object[]{registryManager, connectionType})).andThen(registryByteBuf -> {
            FabricRegistryByteBuf fabricRegistryByteBuf = (FabricRegistryByteBuf)registryByteBuf;
            fabricRegistryByteBuf.fabric_setSendableConfigurationChannels(Set.copyOf(NeoServerConfigurationNetworking.getSendable((ServerConfigurationPacketListenerImpl)this)));
            return registryByteBuf;
        });
    }

    @Inject(method={"runConfiguration"}, at={@At(value="HEAD")})
    private void onPreConfiguration(CallbackInfo ci) {
        ((ServerConfigurationConnectionEvents.Configure)ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.invoker()).onSendConfiguration((ServerConfigurationPacketListenerImpl)this, ((ServerConfigurationPacketListenerImpl)this).server);
    }

    @Override
    public void handleDisconnect() {
        ((ServerConfigurationConnectionEvents.Disconnect)ServerConfigurationConnectionEvents.DISCONNECT.invoker()).onConfigureDisconnect((ServerConfigurationPacketListenerImpl)this, ((ServerConfigurationPacketListenerImpl)this).server);
    }
}

